/**
 * Created by earrieta on 7/25/16.
 */
qrveyWidgetModule = {};

var QrveyNpsWidget = function (module) {
  $ = jQuery;
  var CDN = 'https://s3.amazonaws.com/cdn.qrvey.com/widget/v2/nps/', // 'https://stagingserver.qrvey.com/',
    styleUrl = CDN + 'css/',
    styles = ['analytiq.css', 'main.css', 'charts.css'],
    scriptsUrl = CDN + 'js/',
    scripts = ['dropdown', 'md5', 'moment', 'modal', 'ui-bootstrap.min', 'ui-bootstrap-tpls.min', 'analytiq-services', 'nps.directive'];
  hasAngular = true;

  window.qrveyNpsCDN = CDN;

  function InitAnalytiQ() {
    if (!module) {
      hasAngular = false;
      qrveyWidgetModule = angular.module('QrveyNps', []);
    }
    else {
      qrveyWidgetModule = module;
    }

    var index = 0;

    function recursiveScriptLoad() {
      if (scripts.length == index) {
        qrveyWidgetModule.requires.push('ui.bootstrap');

        startNPSDirective();

        if (!hasAngular)
          angular.bootstrap($('qrvey-nps-results')[0], ['QrveyNps']);
      }
      else
        loadScript(scriptsUrl + scripts[index++] + '.js', recursiveScriptLoad);
    }

    recursiveScriptLoad();
  };

  /*******************************************************
   * Loads
   ******************************************************/
  styles.forEach(function (style) {
    loadCss(styleUrl + style);
  });

  if (window.jQuery == undefined)
    loadScript(CDN + "js/jquery.min.js"); //https://ajax.googleapis.com/ajax/libs/jquery/1.11.2/jquery.min.js
  if (window.angular == undefined)
    loadScript(CDN + 'js/angular.min.js'); //https://ajax.googleapis.com/ajax/libs/angularjs/1.5.8/angular.min.js
  if (window.d3 == undefined)
    loadScript(CDN + "js/d3.v3.min.js"); //http://d3js.org/d3.v3.min.js

  if (module) {
    InitAnalytiQ();
  }
  else {
    var interval = setInterval(function () {
      if (window.jQuery && window.angular && window.d3) {
        clearInterval(interval);
        InitAnalytiQ();
      }
    }, 1000);
  }

  /*******************************************************
   * Other Functions
   ******************************************************/

  function loadScript(url, callback) {
    if (typeof  callback !== 'function')
      callback = function () {
      };

    var script = document.createElement("script");
    script.type = "text/javascript";
    script.async = true;

    if (script.readyState) { //IE
      script.onreadystatechange = function () {
        if (script.readyState == "loaded" || script.readyState == "complete") {
          script.onreadystatechange = null;
          callback();
        }
      };
    } else { //Others
      script.onload = function () {
        callback();
      };
    }

    script.src = url;
    document.getElementsByTagName("head")[0].appendChild(script);
  }

  function loadCss(url) {
    var links = document.getElementsByTagName('link'),
      needCSS = true;
    for (var i = 0; i < links.length; i++) {
      if (links[i].href == url)
        needCSS = false;
    }
    if (needCSS) {
      var ls = document.createElement('link');
      ls.rel = "stylesheet";
      ls.href = url;
      document.getElementsByTagName('head')[0].appendChild(ls);
    }
  }

};

if ('angular' in window) {
  var module = angular.module(angular.element('[ng-app]').attr('ng-app'));
  QrveyNpsWidget(module);
}
else {
  QrveyNpsWidget(null);
}