<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://qrvey.com
 * @since             1.0.0
 * @package           Qrvey_Nps_Results
 *
 * @wordpress-plugin
 * Plugin Name:       qrvey-nps-results
 * Plugin URI:        https://qrvey.com
 * Description:       This Plugin show Charts for Qrvey NPS Question
 * Version:           1.0.0
 * Author:            Qrvey.com <emiro.arrieta@qrvey.com>
 * Author URI:        https://qrvey.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       qrvey-nps-results
 * Domain Path:       /languages
 */

//Widget
$current_dir = dirname(__FILE__);
define('ROW_NAME', 'qrvey_nps_results');
define('USER_ID', 1);

if(array_key_exists("GET_RESULT_DATA", $_POST)) {
	get_post_data();
	exit;
}
else if(array_key_exists("DELETE_RESULT_DATA", $_POST)) {
	delete_post_data();
	exit;
}

include_once($current_dir . '/includes/QrveyNpsResultsWidget.php' );

add_action('widgets_init', function(){
	register_widget('QrveyNpsResultsWidget');
});

add_action('wp_enqueue_scripts', function(){
	wp_register_script( 'nps-angular', plugins_url('/tmpl/nps-angular.js', __FILE__), array('jquery'));
	wp_enqueue_script( 'nps-angular' );
});


//shortcode

add_action( 'admin_menu', 'my_plugin_menu' );

function my_plugin_menu() {
	add_menu_page( 'Qrvey Results', 'Qrvey Results', 'manage_options', 'qrvey-results', 'my_plugin_options');
}

function my_plugin_options() {
	//$fields = ['apiKey', 'userId', 'qrveyId', 'domain', 'histogram'];
	if ( !current_user_can( 'manage_options' ) )  {
		wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
	}

	save_post_data();
	echo load_file('tmpl/form_manager.html');
}

function load_file ($uri){
	ob_start();
	include $uri;
	return ob_get_clean();
}

function save_post_data() {
	$_POST[ROW_NAME]['edited'] = date('Y-m-d H:i:s');
	if(array_key_exists("SAVE_RESULT_DATA", $_POST)) {
	 	$ds = add_user_meta(USER_ID, ROW_NAME, wp_json_encode($_POST[ROW_NAME]) );
	 	echo '<div class="qrvey_info">Data saved. ID : ' . $ds . '</div>';
	}
	else if(array_key_exists("UPDATE_RESULT_DATA", $_POST)) {
		global $wpdb;
		echo '<div class="qrvey_info">Data Updated. ID : ' . $_POST['id'] . '</div>';
		$wpdb->update( 
			$wpdb->usermeta, 
			array('meta_value' => wp_json_encode($_POST[ROW_NAME]) ), 
			array('umeta_id' => $_POST['id']) 
		);
	}
}

function get_post_data() {
	global $wpdb;
	$sql = "SELECT umeta_id, meta_value FROM $wpdb->usermeta WHERE meta_key = '" . ROW_NAME . "' AND user_id = " . USER_ID;
	$results = $wpdb->get_results( $sql, OBJECT );
	
	$output = '[';
	foreach ($results as $value) 
		$output .= str_replace('}', ', "id":' . $value->umeta_id . '},', $value->meta_value);
	echo rtrim($output, ',') . ']';
}

function delete_post_data() {
	global $wpdb;
	$wpdb->delete( $wpdb->usermeta, array('umeta_id' => $_POST['DELETE_RESULT_DATA']) );
	echo 'Data Updated. ID : ' . $_POST['DELETE_RESULT_DATA'] ;
}

// [nps_results id=20]
function nps_results_func( $atts ) {
	if(!array_key_exists("id", $atts))
		return '<div class="qrvey_error error">Cannot find Attribute ID in shortcode</div>';

	global $wpdb;

	$sql = "SELECT meta_value FROM $wpdb->usermeta WHERE umeta_id = " . $atts['id'];
	$res = $wpdb->get_var( $sql );

	$data = json_decode($res, true);

	$tmpl = load_file('tmpl/ui.html');
	foreach($data as $f => $v) 
		$tmpl = str_replace (':' . $f, $v, $tmpl);
	
	$tmpl = str_replace (':histogram', 'false', $tmpl);	
	$tmpl = str_replace (':name', 'Qrvey NPS Results', $tmpl);	
	$tmpl = str_replace (':NPSConfig', 'NPSConfig' . rand(), $tmpl);
	return $tmpl;
}
add_shortcode( 'nps_results', 'nps_results_func' );