<?php
class QrveyNpsResultsWidget extends WP_Widget {
	private $current_dir;
	public $fields = ['apiKey', 'userId', 'qrveyId', 'domain', 'histogram'];

	function __construct() {
		$this->current_dir = dirname(__FILE__);
		$name = __('Qrvey NPS Results Widget');
		parent::__construct(false, $name);
	}

	function form($instance){
		$tmpl = file_get_contents($this->current_dir . '/../tmpl/form.html');
		foreach($this->fields as $f) {
			$str = $instance[$f];
			if($f == 'domain' && empty($str))
				$str = 'https://api.try.qrvey.com';
			else if($f == 'histogram' && $str == 'true')
				$str = 'checked';

			$tmpl = str_replace (':' . $f . 'Name', $this->get_field_name($f), $tmpl);
			$tmpl = str_replace (':' . $f, $str, $tmpl);
		}

		echo $tmpl;
	}

	function update($new_instance, $old_instance){	
		return $new_instance;
	}

	function widget($args, $instance){
		$tmpl = file_get_contents($this->current_dir . '/../tmpl/ui.html');
		foreach($this->fields as $f) {
			$str = $instance[$f];
			$tmpl = str_replace (':' . $f, $str, $tmpl);
		}
		$tmpl = str_replace (':histogram', 'false', $tmpl);	
		$tmpl = str_replace (':name', 'Qrvey NPS Results', $tmpl);	
		$tmpl = str_replace (':NPSConfig', 'NPSConfig' . rand(), $tmpl);
		echo $tmpl;
	}

}